<?php

namespace App\DTO;

use App\Models\Product;
use Spatie\LaravelData\Attributes\DataCollectionOf;
use Spatie\LaravelData\Data;
use Spatie\LaravelData\DataCollection;
use Spatie\LaravelData\Optional;

class ProductDto extends Data
{
    public function __construct(
        public string $sku,
        public string $name,
        public ?string $barcode,
        public SupplierDTO|Optional $supplier,
        #[DataCollectionOf(ProductImageDto::class)]
        public DataCollection|Optional $images,
        #[DataCollectionOf(ProductPricingDto::class)]
        public DataCollection|Optional $pricing,
        public ProductBrandDto|Optional $product_brand,
        public int|null|Optional $brand_id,
        #[DataCollectionOf(ProductAttributeDto::class)]
        public DataCollection|Optional $attributes,
        public string|Optional $weight_unit,
        public string|Optional $dimensions_unit,
        public string $type = Product::TYPE_STANDARD,
        public float $weight = 0,
        public float $unit_cost = 0,

    )
    {
    }
}
