<?php

namespace App\Console\Patches;

use Illuminate\Console\Command;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Schema;

class TaxDiscountPatch extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'TaxDiscountPatch';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Command description';

    /**
     * Create a new command instance.
     *
     * @return void
     */
    public function __construct()
    {
        parent::__construct();
    }

    /**
     * Execute the console command.
     */
    public function handle(): void
    {
        DB::statement('update sales_order_lines set discount_allocation = discount');
        DB::statement('update sales_order_lines set tax_allocation = tax_total');

        Schema::table('sales_order_lines', function (Blueprint $table) {
            $table->dropColumn('discount');
            $table->dropColumn('tax_value');
            $table->dropColumn('tax_rate');
            $table->dropColumn('tax_total');
        });

        Schema::table('sales_orders', function (Blueprint $table) {
            $table->dropColumn('discount');
        });

        /*
         * Reordering of columns
         */

        DB::statement('ALTER TABLE sales_order_lines MODIFY COLUMN proration double(8,2) AFTER tax_allocation');
        DB::statement('ALTER TABLE sales_orders MODIFY COLUMN discount_lines text AFTER fully_paid_at');
        DB::statement('ALTER TABLE sales_orders MODIFY COLUMN tax_lines text AFTER discount_total');
        DB::statement('ALTER TABLE sales_orders MODIFY COLUMN tax_total double(8,2) AFTER tax_lines');
        DB::statement('ALTER TABLE sales_orders MODIFY COLUMN payment_method varchar(255) AFTER payment_status');
        DB::statement('ALTER TABLE sales_orders MODIFY COLUMN is_fba tinyint(1) AFTER tax_total');
    }
}
