<?php

namespace App\Console\Patches\Shopify\Products\Patches;

use Illuminate\Console\Command;

class FixMissingProductInShopifyProducts extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'sku:shopify:products:patch:fix-missing-product-in-shopify-products';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Copy the product_listing_id to product in shopify_products.';

    /**
     * Create a new command instance.
     *
     * @return void
     */
    public function __construct()
    {
        parent::__construct();
    }

    /**
     * Execute the console command.
     */
    public function handle(): int
    {
        ini_set('memory_limit', -1);

        \App\Models\Shopify\ShopifyProduct::with('productListing')
            ->has('productListing')
            ->whereNull('product')
            ->cursor()
            ->each(function ($product) {
                echo $product->id."\n";

                $product->product = $product->productListing->id;
                $product->update();
            });

        return 0;
    }
}
