<?php

namespace App\Console\Patches\Shopify\Products\Patches;

use Illuminate\Console\Command;
use Illuminate\Support\Facades\DB;

class CleanupProductListing extends Command
{
    protected $hidden = true;

    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'sku:patch:shopify:products:cleanup-product-listing';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'fix existing data by removing product_listings for shopify where the shopify_products don’t exist.';

    /**
     * Create a new command instance.
     *
     * @return void
     */
    public function __construct()
    {
        parent::__construct();
    }

    /**
     * Execute the console command.
     */
    public function handle(): int
    {
        DB::delete(
            <<<'SQL'
          DELETE product_listings FROM product_listings 
              LEFT JOIN sales_channels 
                   ON product_listings.sales_channel_id = sales_channels.id
              LEFT JOIN integration_instances
                   ON integration_instances.id = sales_channels.integration_instance_id
              LEFT JOIN integrations
                   ON (integration_instances.integration_id = integrations.id)
              LEFT JOIN shopify_products
                   ON (product_listings.sales_channel_listing_id = shopify_products.variant_id and
                       integration_instances.id = shopify_products.integration_instance_id)
              WHERE integrations.name = 'Shopify'
                   AND (shopify_products.id is NULL OR shopify_products.removed_from_shopify = 1);
          SQL
        );

        return 0;
    }
}
