<?php

namespace App\Console\Patches\Shopify\Orders\Patches;

use App\Models\Integration;
use App\Models\IntegrationInstance;
use App\Models\Shopify\ShopifyOrder;
use Illuminate\Console\Command;

class SyncFulfillments extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'sku:shopify:orders:patch:sync-fulfillments';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = '';

    /**
     * Create a new command instance.
     *
     * @return void
     */
    public function __construct()
    {
        parent::__construct();
    }

    /**
     * Execute the console command.
     */
    public function handle(): int
    {
        /*
         *
         *
         */

        Integration::with(['integrationInstances'])
            ->where('name', Integration::NAME_SHOPIFY)
            ->first()
            ->integrationInstances
            ->each(function (IntegrationInstance $instance) {
                $this->handleForIntegrationInstance($instance);
            });

        return 0;
    }

    protected function handleForIntegrationInstance(IntegrationInstance $instance)
    {
        $auditTrailStartDate = $instance->audit_trail_start_date;

        $maxFulfillmentCount = 6;

        $query = ShopifyOrder::with([])
            ->whereDate('created_at', '>=', $auditTrailStartDate)
            ->whereNotNull('fulfillments')
            ->where('fulfillments', '!=', '[]');

        $query->where(function ($q) use ($maxFulfillmentCount, $auditTrailStartDate) {
            $q->whereRaw('json_extract(fulfillments, "$[0].created_at") >= "'.$auditTrailStartDate.'"');

            for ($i = 1; $i < $maxFulfillmentCount; $i++) {
                $q->orWhereRaw('json_extract(fulfillments, "$['.$i.'].created_at") >= "'.$auditTrailStartDate.'"');
            }
        });

        //
        //            ->whereRaw('json_extract(fulfillments, "$[*].created_at") >= "' . $auditTrailStartDate . '"')
        //            ->whereDate('created_at', '<', $auditTrailStartDate);
        //
        $this->warn('Total Orders Affected: '.$query->count().' for integration instance: '.$instance->name);
        dd($query->toSql(), $query->getBindings());
    }
}
