<?php

namespace App\Console\Patches\Shopify\Orders\Patches;

use Illuminate\Console\Command;
use Illuminate\Support\Facades\DB;

class CopyLineItemsFromShopifyOrdersTable extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'sku:shopify:orders:patch:copy-line-items-from-shopify-orders';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Copy line_items from shopify_orders to shopify_order_line_items';

    /**
     * Create a new command instance.
     *
     * @return void
     */
    public function __construct()
    {
        parent::__construct();
    }

    /**
     * Execute the console command.
     */
    public function handle(): int
    {
        ini_set('memory_limit', -1);

        \App\Models\Shopify\ShopifyOrder::doesntHave('orderLineItems')
            ->cursor()
            ->each(function ($order) {
                echo $order->id."\n";

                DB::transaction(function () use ($order) {
                    $order->createLineItems();
                });
            });

        return 0;
    }
}
