<?php

namespace App\Console\Patches;

use App\Models\SalesOrder;
use Illuminate\Console\Command;

class SetSalesOrderPaymentStatus extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'sku:so-payment-statuses';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Fixes the payment statuses of sales orders';

    /**
     * Execute the console command.
     */
    public function handle(): void
    {
        $affectedOrders = SalesOrder::with(['salesOrderLines', 'payments'])
            ->whereNull('payment_status')
            ->orWhere('payment_status', '=', '')
            ->get();

        $bar = $this->output->createProgressBar($affectedOrders->count());

        $bar->start();

        $affectedOrders->each(function (SalesOrder $salesOrder) use ($bar) {
            $salesOrder->payment_status = SalesOrder::PAYMENT_STATUS_UNPAID;
            $salesOrder->save();

            $bar->advance();
        });

        $bar->finish();
        $this->info("\nSet payment statuses of {$affectedOrders->count()} sales orders.");
    }
}
