<?php

namespace App\Console\Patches;

use Illuminate\Console\Command;
use Illuminate\Support\Facades\DB;

class PortFifoFromSalesCreditLinesToSalesCreditReturnLines extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'sku:fifo-layers:scl-to-scrl';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Ports fifo layer links from sales credit lines to sales credit return lines.';

    /**
     * Execute the console command.
     */
    public function handle(): int
    {
        DB::beginTransaction();

        try {
            $query = <<<SQL
                UPDATE fifo_layers fl 
                    join inventory_movements im on fl.id = im.layer_id 
                    join sales_credit_lines scl on scl.id = fl.link_id 
                    set fl.link_id = im.link_id, 
                        fl.link_type = im.link_type 
                    where im.layer_type = 'App\\\Models\\\FifoLayer' 
                        and fl.link_type = 'App\\\Models\\\SalesCreditLine' 
                        and im.link_type = 'App\\\Models\\\SalesCreditReturnLine' 
                        and `fl`.`original_quantity` = `im`.`quantity`
            SQL;

            DB::unprepared($query);

            DB::commit();
        } catch (\Throwable $e) {
            DB::rollBack();
        }

        return 0;
    }
}
