<?php

namespace App\Console\Patches\Orders\Patches;

use App\Models\SalesOrder;
use Illuminate\Console\Command;

class UpdatePaymentStatusesForRefunds extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'sku:orders:patch:update-payment-statuses-for-refunds';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Set the payment_status for sales orders.';

    /**
     * Create a new command instance.
     *
     * @return void
     */
    public function __construct()
    {
        parent::__construct();
    }

    /**
     * Execute the console command.
     */
    public function handle(): int
    {
        SalesOrder::cursor()->each(function ($salesOrder) {
            $salesOrder->setPaymentStatus();
        });

        return 0;
    }
}
