<?php

namespace App\Console\Patches;

use App\Models\InventoryMovement;
use App\Models\Warehouse;
use Illuminate\Console\Command;
use Illuminate\Database\Eloquent\Builder;

class ClearSupplierWarehouseMovements extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'sku:suppliers-clear-movements';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Clears any inventory movements for supplier warehouse';

    /**
     * Create a new command instance.
     */
    public function __construct()
    {
        parent::__construct();
    }

    /**
     * Execute the console command.
     */
    public function handle(): void
    {
        $matching = InventoryMovement::with(['warehouse'])->whereHas('warehouse', function (Builder $builder) {
            return $builder->where('type', Warehouse::TYPE_SUPPLIER)->orWhereNotNull('supplier_id');
        });

        $total = $matching->count('id');

        $this->info("\nRemoved {$total} movements.\n");

        $matching->delete();
    }
}
