<?php

namespace App\Console\Patches;

use App\Models\Attribute;
use Illuminate\Console\Command;

class ChangeIsDigitalAssetToIsLinkInAttributes extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'sku:attributes:is-digital-asset-to-is-link';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Command description';

    /**
     * Create a new command instance.
     *
     * @return void
     */
    public function __construct()
    {
        parent::__construct();
    }

    /**
     * Execute the console command.
     */
    public function handle(): void
    {
        $query = Attribute::with([])->whereNotNull('display');
        $affected = 0;
        $query->get()->each(function (Attribute $attribute) use (&$affected) {
            if ($attribute['display'] && isset($attribute['display']['is_digital_asset'])) {
                $display = $attribute['display'];
                $display['is_link'] = $display['is_digital_asset'];
                unset($display['is_digital_asset']);
                $attribute->display = $display;
                $attribute->save();
                $affected++;
            }
        });

        $this->info("Changed is_digital_asset to is_link for {$affected} attribute(s)");
    }
}
