<?php

namespace App\Console\Commands\WooCommerce;

use App\Models\SalesChannel;
use App\Models\SalesChannelType;
use Illuminate\Console\Command;

class GetOrders extends \App\Console\Commands\GetOrders
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'sku:woo-commerce:get-orders {salesChannel}';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Retrieve Orders from WooCommerce sales channel';

    /**
     * The console command Sales Channel Type.
     *
     * @var string
     */
    protected $salesChannelType = SalesChannelType::TYPE_WOOCOMMERCE;

    /**
     * Execute the console command of Sales channel type.
     */
    public function handleCommand(SalesChannel $salesChannel): void
    {
        \App\Jobs\WooCommerce\GetOrders::dispatch($salesChannel);
    }
}
