<?php

namespace App\Console\Commands;

use App\Mail\TestMail;
use Illuminate\Console\Command;

class TestEmail extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'test:email {--recipient= : email address to send test message to }';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Send a test email';

    /**
     * Create a new command instance.
     *
     * @return void
     */
    public function __construct()
    {
        parent::__construct();
    }

    /**
     * Execute the console command.
     */
    public function handle(): void
    {
        if ($this->option('recipient')) {
            \Mail::to($this->option('recipient'))->send(new TestMail());
        } else {
            echo 'Please specify a recipient:  --recipient=<email>';
        }
    }
}
