<?php

namespace App\Console\Commands;

use App\Jobs\Amazon;
use App\Jobs\Magento;
use App\Jobs\Shopify;
use App\Models\Integration;
use App\Models\IntegrationInstance;
use Illuminate\Console\Command;
use Illuminate\Database\Eloquent\Builder;

class SyncSalesChannelInventoryCommand extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'sku:sync-inventory
                                {--i|integrationInstance=* : The IDs of the integration instance}';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Sync Sales Channels Inventory';

    /**
     * Execute the console command.
     */
    public function handle(): void
    {
        IntegrationInstance::with(['integration'])->whereHas('integration', function (Builder $builder) {
            $builder->where('integration_type', Integration::TYPE_SALES_CHANNEL);
        })->when(! empty($this->option('integrationInstance')), function (Builder $builder) {
            $builder->whereIn('id', $this->option('integrationInstance'));
        })->each(function (IntegrationInstance $integrationInstance) {
            if ($integrationInstance->isAmazonInstance()) {
                // TODO: Make sure it is handled in SKU-6621
            } elseif ($integrationInstance->isShopify()) {
                Shopify\ShopifySyncInventoryJob::dispatch($integrationInstance)->onQueue('syncInventory');
            } elseif ($integrationInstance->isMagento()) {
                Magento\SyncInventoryJob::dispatch($integrationInstance)->onQueue('sales-channels');
            } else {
                $this->warn("The {$integrationInstance->integration->name}({$integrationInstance->name}) not implemented yet.");
            }
        });
    }
}
