<?php

namespace App\Console\Commands;

use App\Jobs\SyncBackorderQueueCoveragesJob;
use Illuminate\Console\Command;

class SyncBackorderQueueCoveragesCommand extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'sku:backorders:sync-coverages';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Syncs backorder queue coverages with PO line quantities.';

    /**
     * Execute the console command.
     */
    public function handle(): void
    {
        dispatch((new SyncBackorderQueueCoveragesJob())->withGlobalCoverage());
    }
}
