<?php

namespace App\Console\Commands\Starshipit;

use App\Models\SalesOrderFulfillment;
use Illuminate\Console\Command;

class Resubmit extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'sku:starshipit:resubmit';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Resubmit Starshipit orders (orphans)';

    /**
     * Create a new command instance.
     *
     * @return void
     */
    public function __construct()
    {
        parent::__construct();
    }

    /**
     * Execute the console command.
     */
    public function handle(): int
    {
        SalesOrderFulfillment::with([])
            ->where('status', SalesOrderFulfillment::STATUS_SUBMITTED)
            ->where('fulfillment_type', SalesOrderFulfillment::TYPE_STARSHIPIT)
            ->each(function (SalesOrderFulfillment $fulfillment) {
                $order = \App\Models\Starshipit\Mysql\Order::with([])->where('sku_fulfillment_id', $fulfillment->id)->first();

                if (! $order) {
                    echo $fulfillment->fulfillment_number."\n";
                    $submitResponse = \App\Jobs\Starshipit\SubmitOrders::submitOrderFulfillmentToStarshipit($fulfillment);
                    if (! $submitResponse['success']) {
                        echo $fulfillment->fulfillment_number.' failed to submit'."\n";
                        print_r($submitResponse);
                    }

                    $fulfillment->salesOrder->updateFulfillmentStatus($fulfillment->fulfilled_at);
                }
            });

        return Command::SUCCESS;
    }
}
