<?php

namespace App\Console\Commands\SphinxSearch;

use App\Lib\SphinxSearch\SphinxSearch;
use Illuminate\Console\Command;

class InstallEngine extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'sphinx:install-engine';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Install SphinxSE in MariaDB';

    /**
     * Create a new command instance.
     *
     * @return void
     */
    public function __construct()
    {
        parent::__construct();
    }

    /**
     * Execute the console command.
     */
    public function handle(): void
    {
        $result = SphinxSearch::installEngine(\DB::connection('mysql'));

        if ($result) {
            $this->info('SphinxSearch gateway engine SphinxSE was installed in MariaDB.');
        } else {
            $this->error('SphinxSearch gateway engine SphinxSE was not installed in MariaDB.');
        }

        $result = SphinxSearch::setupGateway(\DB::connection('mysql'));

        if ($result) {
            $this->info('SphinxSearch gateway database "'.env('SPHINX_GATEWAY_DB', 'sphinx').'" was created in MariaDB.');
        } else {
            $this->error('SphinxSearch gateway database "'.env('SPHINX_GATEWAY_DB', 'sphinx').'" was NOT created in MariaDB.');
        }
    }
}
