<?php

namespace App\Console\Commands\SphinxSearch;

use App\Lib\SphinxSearch\SphinxSearch;
use Illuminate\Console\Command;

class IndexSetup extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'sphinx:index-setup {indexName=0 : the name of the index to setup}';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Creates MariaDB gateway tables for SphinxSE indexes as defined in configuration file (config/sphinx.php)';

    /**
     * Create a new command instance.
     *
     * @return void
     */
    public function __construct()
    {
        parent::__construct();
    }

    /**
     * Execute the console command.
     */
    public function handle(): void
    {
        $indexes = ! empty($this->argument('indexName', null)) ?
      [strtolower($this->argument('indexName', null))] :
      SphinxSearch::indexes();

        foreach ($indexes as $index) {
            $this->info('Setting up index '.$index.'.');
            $result = SphinxSearch::setupGatewayTable($index);
        }

        if ($result) {
            $this->info('Done.');
        } else {
            $this->error('Failed to setup SphinxSearch index.');
        }
    }
}
