<?php

namespace App\Console\Commands\SphinxSearch;

use App\Lib\SphinxSearch\SphinxSearch;
use Illuminate\Console\Command;

class IndexRebuild extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'sphinx:index-rebuild {indexName=0 : the name of the index to rebuild}';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Rebuild SphinxSE indexes';

    /**
     * Create a new command instance.
     *
     * @return void
     */
    public function __construct()
    {
        parent::__construct();
    }

    /**
     * Execute the console command.
     */
    public function handle(): void
    {
        $indexes = ! empty($this->argument('indexName', null)) ? [strtolower($this->argument('indexName', null))] : SphinxSearch::indexes();

        $conn = \DB::connection('mysql');

        foreach ($indexes as $index) {
            $this->info('Rebuilding index '.$index.'.');
            $result = SphinxSearch::rebuild($index);
        }

        if ($result) {
            $this->info('Done.');
        } else {
            $this->error('SphinxSearch index failed to rebuild.');
        }

        $this->info('Waiting for SphinxSearch async tasks to finish.');
    }
}
