<?php

namespace App\Console\Commands;

use App\Notifications\MonitoringMessage;
use Illuminate\Console\Command;
use Illuminate\Support\Facades\Notification;

class SlackNotify extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    //protected $signature = 'slack:alert {--recipient= : email address to send test message to }';
    protected $signature = 'slack:notify {--message= : message to send }';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Send a test email';

    /**
     * Create a new command instance.
     *
     * @return void
     */
    public function __construct()
    {
        parent::__construct();
    }

    /**
     * Execute the console command.
     */
    public function handle(): void
    {
        if ($this->option('message')) {
            Notification::route('slack', config('slack.alerts'))->notify(new MonitoringMessage($this->option('message')));
        } else {
            echo "Please specify a message:  --message=<text>\n";
        }
    }
}
