<?php

namespace App\Console\Commands\Shopify;

use App\Models\IntegrationInstance;
use Illuminate\Console\Command;

class ShopifyGetUnitCosts extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'sku:shopify:get-unit-costs 
                          {integrationInstance : The ID of the integration instance}
                          {--i|ids=* : Specify inventory item ids }';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Get Shopify product unit costs for the given integration instance.';

    /**
     * Create a new command instance.
     *
     * @return void
     */
    public function __construct()
    {
        parent::__construct();
    }

    /**
     * Execute the console command.
     */
    public function handle(): void
    {
        $integrationInstance = IntegrationInstance::with('integration')->findOrFail($this->argument('integrationInstance'));
        if (! $integrationInstance || ! $integrationInstance->isShopify()) {
            $this->error('The integration must be Shopify.');

            return;
        }

        dispatch(new \App\Jobs\Shopify\ShopifyGetUnitCosts($integrationInstance, $this->getCommandOptions()))->onQueue('sales-channels');

        $this->info('Added Shopify product unit costs request to the Queue, it will be processed shortly.');
    }

    protected function getCommandOptions(): array
    {
        $options = [];

        if ($this->option('ids')) {
            $options['ids'] = implode(',', $this->option('ids'));
        }

        return $options;
    }
}
