<?php

namespace App\Console\Commands\Shopify;

use App\Models\Integration;
use App\Models\IntegrationInstance;
use Illuminate\Console\Command;

class ShopifyGetShippingServices extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'sku:shopify:get-shipping-services
                          {integrationInstance : The ID of the integration instance}';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Retrieve shipping services from Shopify';

    /**
     * Execute the console command.
     */
    public function handle(): void
    {
        // get and check integration instance belongs to shopify integration
        $integrationInstance = IntegrationInstance::with(['integration'])->findOrFail($this->argument('integrationInstance'));

        if ($integrationInstance->integration->name !== Integration::NAME_SHOPIFY) {
            $this->error('The integration instance type must be Shopify');

            return;
        }

        dispatch(new \App\Jobs\Shopify\ShopifyGetShippingServices($integrationInstance));

        $this->info('Added to the Queue, it will be process shortly');
    }
}
