<?php

namespace App\Console\Commands\Shopify;

use App\Integrations\Shopify;
use App\Models\IntegrationInstance;
use App\Models\Shopify\ShopifyWebhook;
use Illuminate\Console\Command;
use Illuminate\Support\Str;

class ShopifyDeleteWebhooksCommand extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'sku:shopify:delete-webhooks
                                 {integrationInstance : The ID of the integration instance}';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Delete shopify webhooks that listening on inventoryItemDelete/inventoryLevelUpdate';

    /**
     * Execute the console command.
     */
    public function handle(): void
    {
        $integrationInstance = IntegrationInstance::with('integration')->findOrFail($this->argument('integrationInstance'));
        if (! $integrationInstance || ! $integrationInstance->isShopify()) {
            $this->error('The integration must be Shopify.');

            return;
        }

        $shopify = new Shopify($integrationInstance);

        foreach (ShopifyWebhook::getWebhooks($integrationInstance->id) as $webhook) {
            if (Str::startsWith($webhook->address, config('app.url'))) {
                try {
                    // delete shopify webhook by id
                    $shopify->deleteWebhook($webhook->shopify_webhook_id);
                    $webhook->delete();
                } catch (\Throwable $exception) {
                    $this->error("{$webhook->shopify_webhook_id}@$webhook->topic: ".$exception->getMessage());
                }
            }
        }
    }
}
