<?php

namespace App\Console\Commands\Shopify;

use App\Models\IntegrationInstance;
use Illuminate\Console\Command;

class ShopifyCreateSkuProducts extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'sku:shopify:create-sku-products
                                {integrationInstance : The ID of the integration instance}';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Create sku products from mapped shopify fields';

    /**
     * Create a new command instance.
     *
     * @return void
     */
    public function __construct()
    {
        parent::__construct();
    }

    /**
     * Execute the console command.
     */
    public function handle(): void
    {
        /** @var IntegrationInstance $integrationInstance */
        $integrationInstance = IntegrationInstance::with('integration')->findOrFail($this->argument('integrationInstance'));
        if (! $integrationInstance || ! $integrationInstance->isShopify()) {
            $this->error('The integration must be Shopify.');

            return;
        }

        dispatch(new \App\Jobs\Shopify\ShopifyCreateSkuProducts($integrationInstance))->onQueue('sales-channels');

        $this->info('Added create sku products request to the Queue, it will be processed shortly.');
    }
}
