<?php

namespace App\Console\Commands\Shopify;

use App\Console\Commands\AbstractIntegrationInstanceCommand;
use App\Integrations\Shopify;
use App\Models\IntegrationInstance;
use Carbon\Carbon;

class ShopifyAutoDownloadProducts extends AbstractIntegrationInstanceCommand
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'sku:shopify:auto-download-products {integrationInstanceId?}
                                {--createdAfter= : A date used for selecting orders created after (or at) a specified time.  }
                                {--createdBefore= : A date used for selecting orders created before (or at) a specified time.  }
                                {--lastUpdatedAfter= : A date used for selecting orders that were last updated after (or at) a specified time.  }
                                {--lastUpdatedBefore= : A date used for selecting orders that were last updated before (or at) a specified time.  }';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Auto downloads Shopify products';

    /**
     * Execute the console command.
     */
    public function handle(): void
    {
        /**
         * Indicate that changes should be based on updated_at date.
         */
        Shopify::filterChangesByUpdatedAt();

        $this->integrationInstances()->each(function (IntegrationInstance $integrationInstance) {
            dispatch(new \App\Jobs\Shopify\ShopifyGetProducts($integrationInstance, $this->getCommandOptions()))->onQueue('sales-channels');
        });

        $this->info('Added to the Queue, it will be processed shortly');
    }

    protected function getCommandOptions(): array
    {
        $options = [];

        if ($this->option('createdAfter')) {
            $options['created_after'] = Carbon::parse($this->option('createdAfter'));
        }
        if ($this->option('createdBefore')) {
            $options['created_before'] = Carbon::parse($this->option('createdBefore'));
        }
        if ($this->option('lastUpdatedAfter')) {
            $options['updated_after'] = Carbon::parse($this->option('lastUpdatedAfter'));
        }
        if ($this->option('lastUpdatedBefore')) {
            $options['updated_before'] = Carbon::parse($this->option('lastUpdatedBefore'));
        }

        return $options;
    }
}
