<?php

namespace App\Console\Commands\ShipStation;

use App\Models\Integration;
use App\Models\IntegrationInstance;
use Illuminate\Console\Command;

class SubmitOrders extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'sku:shipstation:submit-orders';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Submit orders to ShipStation';

    /**
     * Execute the console command.
     */
    public function handle(): void
    {
        /** @var IntegrationInstance $integration */
        $integration = Integration::with([])->where('name', Integration::NAME_SHIPSTATION)->firstOrFail();

        $integrationInstance = $integration->integrationInstances()->first();

        if (! $integrationInstance) {
            $this->error('There is no instance for '.$integration->name);

            return;
        }

        dispatch(new \App\Jobs\ShipStation\SubmitOrders($integrationInstance));

        $this->info('Added to the Queue, it will be process shortly');
    }
}
