<?php

namespace App\Console\Commands\ShipStation;

use App\Models\Integration;
use App\Models\IntegrationInstance;
use Illuminate\Console\Command;

class GetShippingServices extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'sku:shipstation:get-shipping-services
                          {integrationInstance : The ID of the integration instance}';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Retrieve shipping services from ShipStation';

    /**
     * Execute the console command.
     */
    public function handle(): void
    {
        // get and check integration instance belongs to amazon integration
        $integrationInstance = IntegrationInstance::with(['integration'])->findOrFail($this->argument('integrationInstance'));

        if ($integrationInstance->integration->name !== Integration::NAME_SHIPSTATION) {
            $this->error('The integration instance type must be ShipStation');

            return;
        }

        dispatch(new \App\Jobs\ShipStation\GetShippingServices($integrationInstance));

        $this->info('Added to the Queue, it will be process shortly');
    }
}
