<?php

namespace App\Console\Commands;

use App\Models\BackorderQueue;
use Illuminate\Console\Command;

class ResetBackorderQueuePriority extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'sku:backorder-queue:reset-priority';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Resets the backorder queue priority based on id.';

    /**
     * Execute the console command.
     */
    public function handle(): void
    {
        set_time_limit(0);

        $priority = 1;
        BackorderQueue::with([])
            ->active()
            ->each(function (BackorderQueue $queue) use (&$priority) {
                $queue->priority = $priority++;
                $queue->save();
            });
        $this->info('Priority reset.');
    }
}
