<?php

namespace App\Console\Commands\Reporting;

use App\Jobs\RecacheProfitReportingJob;
use App\Models\SalesOrder;
use Illuminate\Console\Command;
use Illuminate\Database\Eloquent\Builder;

class RecacheProfitReportingCommand extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'sku:reporting:recache 
                                    {--i|ids= : Specify product ids by comma separated}';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Re-Cache profit reporting';

    /**
     * Execute the console command.
     */
    public function handle(): void
    {
        if (! $this->confirm('This command will truncate reporting tables, continue?')) {
            return;
        }

        $productIds = $this->option('ids') ? explode(',', $this->option('ids')) : [];

        // progress bar
        $bar = $this->output->createProgressBar(SalesOrder::query()->when($productIds, function (Builder $query) use ($productIds) {
            $query->whereHas('salesOrderLines', fn ($q) => $q->whereIn('product_id', $productIds));
        })->count());
        $bar->start();

        (new RecacheProfitReportingJob($productIds))->setProgressBar($bar)->handle();

        $bar->finish();

        $this->info("\nDONE");
    }
}
