<?php

namespace App\Console\Commands;

use App\Models\SalesOrderLine;
use Illuminate\Console\Command;
use Illuminate\Support\Facades\DB;

class RefreshHasBackorderCache extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'sku:refresh-has-backorder-cache';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Refreshes the has_backorder cache for sales order lines.';

    /**
     * Execute the console command.
     */
    public function handle(): int
    {
        SalesOrderLine::query()
            ->leftJoinRelationship('backorderQueue')
            ->update(['has_backorder' => DB::raw('IF(`backorder_queues`.`backordered_quantity` > `backorder_queues`.`released_quantity`, 1, 0)')]);

        return 0;
    }
}
