<?php

namespace App\Console\Commands;

use App\Notifications\MonitoringMessage;
use Illuminate\Console\Command;
use Illuminate\Support\Carbon;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Notification;

class QueueAlertBatches extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'queue:alert-batches
                            {--hours=1 : The minimum number of hours to alert on batch data}';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Sends notifications when there are long running job batches';

    /**
     * Execute the console command.
     */
    public function handle(): int
    {
        $longJobs = DB::table('job_batches')
            ->select('name', 'total_jobs', 'pending_jobs')
            ->whereNull('finished_at')
            ->where('created_at', '<', Carbon::now()->subHours($this->option('hours'))->getTimestamp())
            ->get();

        foreach ($longJobs as $longJob) {
            Notification::route('slack', config('slack.alerts'))->notify(new MonitoringMessage(config('app.url').' Long Running Batch: '.$longJob->name.', stuck at ('.($longJob->total_jobs - $longJob->pending_jobs).'/'.$longJob->total_jobs.')'));
        }

        return 0;
    }
}
