<?php

namespace App\Console\Commands\Products;

use App\Jobs\InvalidateDailyAverageConsumptionForProductsJob;
use Illuminate\Console\Command;
use Illuminate\Support\Arr;

class InvalidateDailyAverageConsumptionCommand extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'sku:products:invalidate-daily-average-consumption {--id= : ID of Product}';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Invalidate Daily Average Consumption for Products';

    /**
     * Execute the console command.
     */
    public function handle(): int
    {
        dispatch(new InvalidateDailyAverageConsumptionForProductsJob(Arr::wrap($this->option('id'))));

        return Command::SUCCESS;
    }
}
