<?php

namespace App\Console\Commands\Products;

use App\Jobs\GenerateCacheDailyAverageConsumptionForProductsJob;
use Illuminate\Console\Command;

class CacheDailyAverageConsumptionCommand extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'sku:products:cache-daily-average-consumption {--id= : ID of Product}';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Cache Daily Average Consumption for Products';

    /**
     * Execute the console command.
     */
    public function handle(): int
    {
        dispatch(new GenerateCacheDailyAverageConsumptionForProductsJob([$this->option('id')]))->onQueue('products');

        return Command::SUCCESS;
    }
}
