<?php

namespace App\Console\Commands\Patches;

use App\Models\Warehouse;
use Illuminate\Console\Command;

/*
 * Currently this just fixes supplier warehouses.  If there are future duplicate warehouse issues, we can update this patch.
 *
 * @see: Test\Feature\Patches\FixDuplicateWarehousesTest
 */
class FixDuplicateWarehousesCommand extends Command
{
    protected $signature = 'patch:fix-duplicate-warehouses';

    protected $description = 'Fix Duplicate Warehouses';

    public function handle(): void
    {
        // Query for duplicate warehouses by name
        Warehouse::query()
            ->selectRaw('name, supplier_id, integration_instance_id, COUNT(*) as count')
            ->groupBy('name')
            ->having('count', '>', 1)
            ->each(function ($warehouse) {
                // Fix supplier warehouse duplicates
                Warehouse::with('supplier')
                    ->where('name', $warehouse->name)
                    ->whereHas('supplier')
                    ->each(function (Warehouse $supplierWarehouse) {
                        $supplierWarehouse->name = $supplierWarehouse->supplier->name . ' - ' . $supplierWarehouse->name;
                        $supplierWarehouse->save();
                    });
            });
    }
}
