<?php

namespace App\Console\Commands\Magento;

use App\Helpers\YamlHelper;
use App\Models\IntegrationInstance;
use Illuminate\Console\Command;

class GetProducts extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'sku:magento:get-products 
                          {integrationInstance : The ID of the integration instance}
                          {--createdAfter= : Return products created after a specified date. }
                          {--createdBefore= : Return products created before a specified date. }
                          {--lastUpdatedAfter= : Return products last updated after a specified date. }
                          {--lastUpdatedBefore= : Return products last updated before a specified date. }
                          {--lastUpdatedAfterLastFetched : Return products last updated after the date of the last fetched. }
                          {--l|limit=250 : Return up to this many results per page. }
                          {--debug : Run the job synchronously instead of queueing it for the purpose of debugging}';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Get magento products for the given integration instance.';

    /**
     * Execute the console command.
     */
    public function handle(): int
    {
        /** @var IntegrationInstance $integrationInstance */
        $integrationInstance = IntegrationInstance::query()
            ->findOrFail($this->argument('integrationInstance'));

        if (! $integrationInstance || ! $integrationInstance->isMagento()) {
            $this->error('The integration must be Magento.');

            return 0;
        }

        $job = new \App\Jobs\Magento\GetProducts($integrationInstance, $this->options());

        if ($this->option('debug')) {
            $result = $job->handle();
            $this->info(YamlHelper::dump($result));
        } else {
            dispatch($job)->onQueue('sales-channels');
            $this->info('Added Magento products request to the Queue, it will be processed shortly.');
        }
    }
}
