<?php

namespace App\Console\Commands\Magento;

use App\Jobs\Magento\GetProductAttributesJob;
use App\Models\IntegrationInstance;
use Illuminate\Console\Command;

class GetProductAttributesCommand extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'sku:magento:get-product-attributes
                                {integrationInstance : The ID of the integration instance}
                                {--debug : Do not queue, run inline }';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Retrieve Orders from Magento sales channel';

    /**
     * Execute the console command.
     */
    public function handle(): int
    {
        /** @var IntegrationInstance $integrationInstance */
        $integrationInstance = $this->argument('integrationInstance') instanceof IntegrationInstance ?
          $this->argument('integrationInstance') :
          IntegrationInstance::with(['integration'])->findOrFail($this->argument('integrationInstance'));

        if (! $integrationInstance->isMagento()) {
            $this->error('The integration instance type must be Magento');

            return 0;
        }

        if ($this->option('debug')) {
            dispatch_sync(new GetProductAttributesJob($integrationInstance, $this->options()));
        } else {
            $this->info('Dispatching the "GetProductAttributes" Magento job');
            dispatch(new GetProductAttributesJob($integrationInstance, $this->options()))->onQueue('sales-channels');
        }
    }
}
