<?php

namespace App\Console\Commands\Magento;

use App\Jobs\Magento\GetInventorySourcesJob;
use App\Models\IntegrationInstance;
use Illuminate\Console\Command;

class GetInventorySourcesCommand extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'sku:magento:get-inventory-sources
                                {integrationInstance : The ID of the integration instance}
                                {--debug : Do not queue, run inline }';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Retrieve inventory sources from Magento integration instance';

    /**
     * Execute the console command.
     */
    public function handle(): int
    {
        /** @var IntegrationInstance $integrationInstance */
        $integrationInstance = $this->argument('integrationInstance') instanceof IntegrationInstance ?
          $this->argument('integrationInstance') :
          IntegrationInstance::with(['integration'])->findOrFail($this->argument('integrationInstance'));

        if (! $integrationInstance->isMagento()) {
            $this->error('The integration instance type must be Magento');

            return 0;
        }

        if ($this->option('debug')) {
            dispatch_sync(new GetInventorySourcesJob($integrationInstance));
        } else {
            $this->info('Dispatching the "GetInventorySources" Magento job');
            dispatch(new GetInventorySourcesJob($integrationInstance))->onQueue('sales-channels');
        }
    }
}
