<?php

namespace App\Console\Commands\Magento;

use App\Jobs\Magento\GetCustomerGroupsJob;
use App\Models\IntegrationInstance;
use Illuminate\Console\Command;

class GetCustomerGroupsCommand extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'sku:magento:get-customer-groups
                                {integrationInstance : The ID of the integration instance}
                                {--debug : Do not queue, run inline }';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Get the customer groups from the Magento instance';

    /**
     * Execute the console command.
     */
    public function handle(): int
    {
        /** @var IntegrationInstance $integrationInstance */
        $integrationInstance = $this->argument('integrationInstance') instanceof IntegrationInstance ? $this->argument('integrationInstance') : IntegrationInstance::with(['integration'])->findOrFail($this->argument('integrationInstance'));

        if (! $integrationInstance->isMagento()) {
            $this->error('The integration instance type must be Magento');

            return 0;
        }

        if ($this->option('debug')) {
            dispatch_sync(new GetCustomerGroupsJob($integrationInstance));
        } else {
            $this->info('Dispatching the "GetOrders" Magento job');
            dispatch(new GetCustomerGroupsJob($integrationInstance))->onQueue('sales-channels');
        }
    }
}
