<?php

namespace App\Console\Commands\Magento;

use App\Models\IntegrationInstance;
use Illuminate\Console\Command;

class CreateSkuProducts extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'sku:magento:create-sku-products
                                {integrationInstance : The ID of the integration instance}';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Create sku products from mapped magento fields';

    /**
     * Create a new command instance.
     *
     * @return void
     */
    public function __construct()
    {
        parent::__construct();
    }

    /**
     * Execute the console command.
     */
    public function handle(): int
    {
        /** @var IntegrationInstance $integrationInstance */
        $integrationInstance = IntegrationInstance::with('integration')->findOrFail($this->argument('integrationInstance'));
        if (! $integrationInstance || ! $integrationInstance->isMagento()) {
            $this->error('The integration must be Magento.');

            return -1;
        }

        dispatch(new \App\Jobs\Magento\CreateSkuProducts($integrationInstance))->onQueue('sales-channels');

        $this->info('Added create sku products request to the Queue, it will be processed shortly.');

        return 0;
    }
}
