<?php

namespace App\Console\Commands\Magento;

use App\Console\Commands\AbstractIntegrationInstanceCommand;
use App\Models\IntegrationInstance;

class AutoDownloadProducts extends AbstractIntegrationInstanceCommand
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'sku:magento:auto-download-products {integrationInstanceId?}';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Auto downloads products of the Magento instances';

    /**
     * Execute the console command.
     */
    public function handle(): void
    {
        $this->integrationInstances()->each(function (IntegrationInstance $integrationInstance) {
            dispatch(new \App\Jobs\Magento\GetProducts($integrationInstance, ['lastUpdatedAfterLastFetched' => true]))->onQueue('sales-channels');
        });
    }
}
