<?php

namespace App\Console\Commands\Magento;

use App\Console\Commands\AbstractIntegrationInstanceCommand;
use App\Enums\DownloadedBy;
use App\Models\IntegrationInstance;

class AutoDownloadOrders extends AbstractIntegrationInstanceCommand
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'sku:magento:auto-download-orders {integrationInstanceId?}
                                {--createdAfter= : A date used for selecting orders created after (or at) a specified time.  }
                                {--createdBefore= : A date used for selecting orders created before (or at) a specified time.  }
                                {--lastUpdatedAfter= : A date used for selecting orders that were last updated after (or at) a specified time.  }
                                {--lastUpdatedBefore= : A date used for selecting orders that were last updated before (or at) a specified time.  }
                                {--downloadedBy='.DownloadedBy::Job.' : A flag to add to orders that will be downloaded. }';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Auto downloads Magento orders';

    /**
     * Execute the console command.
     */
    public function handle(): void
    {
        $this->integrationInstances()->each(function (IntegrationInstance $integrationInstance) {
            dispatch(new \App\Jobs\Magento\GetOrdersJob($integrationInstance, $this->options()))->onQueue('sales-channels');
        });
    }
}
