<?php

namespace App\Console\Commands;

use App\Console\Commands\Inventory\Health\Fix\FixExternallyFulfilledSalesOrderLinesWithMovementsCommandHelper;
use App\Console\Commands\Inventory\Health\Fix\FixFulfillmentReleaseInventoryMovementsMissingFulfillmentLinesCommandHelper;
use App\Console\Commands\Inventory\Health\Fix\FixMissingFulfillmentMovementsCommandHelper;
use App\Console\Commands\Inventory\Health\Fix\FixMissingSalesOrderMovementsCommandHelper;
use App\Console\Commands\Inventory\Health\Fix\FixMissingSalesOrderReservationMovementsCommandHelper;
use App\Console\Commands\Inventory\Health\Fix\FixNonInventoryProductsWithInventoryMovementsCommandHelper;
use App\Console\Commands\Inventory\Health\Fix\FixOrphanSalesOrderLineReservationMovementsCommandHelper;
use App\Console\Commands\Inventory\Health\Fix\FixOversubscribedFifoLayersCommandHelper;
use App\Console\Commands\Inventory\Health\Fix\FixStaleSalesOrderLineLayersCacheCommandHelper;
use Illuminate\Console\Command;
use function Laravel\Prompts\multiselect;

class InventoryHealthCommand extends Command
{
    protected $signature = 'sku:inventory:health';

    protected $description = 'Identify and fix any inventory issues.';

    protected FixMissingSalesOrderMovementsCommandHelper $missingSalesOrderMovements;
    protected FixMissingSalesOrderReservationMovementsCommandHelper $missingSalesOrderReservationMovements;
    protected FixMissingFulfillmentMovementsCommandHelper $missingFulfillmentMovements;
    protected FixOversubscribedFifoLayersCommandHelper $overSubscribedFifoLayers;
    protected FixStaleSalesOrderLineLayersCacheCommandHelper $staleSalesOrderLineLayersCache;
    protected FixExternallyFulfilledSalesOrderLinesWithMovementsCommandHelper $externallyFulfilledSalesOrderLinesWithMovements;
    protected FixFulfillmentReleaseInventoryMovementsMissingFulfillmentLinesCommandHelper $fulfillmentReleaseInventoryMovementsMissingFulfillmentLines;
    protected FixOrphanSalesOrderLineReservationMovementsCommandHelper $fixOrphanSalesOrderLineReservationMovements;
    protected FixNonInventoryProductsWithInventoryMovementsCommandHelper $fixNonInventoryProductsWithInventoryMovements;

    protected array $options = [];

    public function __construct()
    {
        parent::__construct();
        $this->missingSalesOrderMovements = app(FixMissingSalesOrderMovementsCommandHelper::class);
        $this->missingSalesOrderReservationMovements = app(FixMissingSalesOrderReservationMovementsCommandHelper::class);
        $this->missingFulfillmentMovements = app(FixMissingFulfillmentMovementsCommandHelper::class);
        $this->overSubscribedFifoLayers = app(FixOversubscribedFifoLayersCommandHelper::class);
        $this->staleSalesOrderLineLayersCache = app(FixStaleSalesOrderLineLayersCacheCommandHelper::class);
        $this->externallyFulfilledSalesOrderLinesWithMovements = app(FixExternallyFulfilledSalesOrderLinesWithMovementsCommandHelper::class);
        $this->fulfillmentReleaseInventoryMovementsMissingFulfillmentLines = app(FixFulfillmentReleaseInventoryMovementsMissingFulfillmentLinesCommandHelper::class);
        $this->fixOrphanSalesOrderLineReservationMovements = app(FixOrphanSalesOrderLineReservationMovementsCommandHelper::class);
        $this->fixNonInventoryProductsWithInventoryMovements = app(FixNonInventoryProductsWithInventoryMovementsCommandHelper::class);

        // Dynamically build the options array
        foreach (get_object_vars($this) as $name => $value) {
            if (is_object($value) && method_exists($value, 'getDescription')) {
                $this->options[$name] = $value->getDescription();
            }
        }
    }

    public function handle(): void
    {
        do {
            $choices = multiselect(
                label: 'What would you like to fix?',
                options: $this->options,
                scroll: 100,
            );

            foreach($choices as $choice) {
                ($this->{$choice})();
            }

            $continue = $this->confirm('Would you like to fix anything else?');
        } while ($continue);
    }
}
