<?php

namespace App\Console\Commands\Inventory;

use App\Jobs\SyncExternallyFulfilledJob;
use Illuminate\Console\Command;

class SyncExternallyFulfilledCommand extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'sku:inventory:sync-externally-fulfilled
                            {--ids= : Specify orders }';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Sync externally fulfilled quantity for sales order lines';

    /**
     * Execute the console command.
     */
    public function handle(): void
    {
        $this->info('Syncing externally fulfilled quantity for sales order lines');

        $ids = $this->option('ids') ?? [];
        dispatch(new SyncExternallyFulfilledJob($ids));
    }
}
