<?php

namespace App\Console\Commands\Inventory;

use App\Jobs\UpdateProductsInventoryAndAvgCost;
use Illuminate\Console\Command;

class RefreshProductsInventory extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'sku:inventory:refresh
                            {--p|products= : Specify products }
                            {--without-inventory : Do not update inventory count }
                            {--without-avg-cost : Do not update average cost }';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Refresh products inventory count and average cost';

    /**
     * Execute the console command.
     */
    public function handle(): void
    {
        // dispatching the job
        $this->info('Refreshing the products inventory count and average cost');

        $products = $this->option('products') ? explode(',', $this->option('products')) : [];

        $updateJob = new UpdateProductsInventoryAndAvgCost($products);

        $updateJob->setUpdateInventory(! $this->option('without-inventory'))
            ->setUpdateInventory(! $this->option('without-avg-cost'))
            ->setAllowAllProducts(true);

        dispatch($updateJob)->onQueue('import-export');
    }
}
