<?php

namespace App\Console\Commands\Inventory\Patches;

use Illuminate\Console\Command;
use Illuminate\Support\Facades\DB;

class FixShopifyNoRestockRefunds extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'sku:inventory:patch:fix-shopify-no-restock-refunds
                                {--debug : Debug mode }';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Fix Shopify No Restock Refunds';

    /**
     * Create a new command instance.
     *
     * @return void
     */
    public function __construct()
    {
        parent::__construct();
    }

    /**
     * Execute the console command.
     */
    public function handle(): int
    {
        /*
         * Shopify order lines with quantity > 1, a fulfillment, and a refund
         */
        ini_set('memory_limit', '4G');

        $sql = '
CREATE TEMPORARY TABLE IF NOT EXISTS temporary_shopify_line_items (
    `line_item_id` bigint(20) unsigned,
    `shopify_sales_order_id` bigint(20) unsigned,
    `sales_order_name` varchar(255),
    `sku` varchar(255),
    `quantity` int(11),
    `fulfillment_status` varchar(255),
    `json_object` mediumtext,
    PRIMARY KEY (`line_item_id`), INDEX (`quantity`)
) ENGINE=InnoDB DEFAULT COLLATE utf8_unicode_ci
        ';

        DB::statement($sql);

        $results = DB::select('SELECT id, `name`, JSON_EXTRACT(json_object, "$.line_items") as line_items FROM shopify_orders');
        $this->info(count($results));

        foreach ($results as $result) {
            $lineItems = json_decode($result->line_items);
            foreach ($lineItems as $lineItem) {
                if ($lineItem->quantity == 1 || ! in_array($lineItem->fulfillment_status, ['fulfilled', 'partial'])) {
                    continue;
                }
                $sql = "INSERT INTO temporary_shopify_line_items VALUES($lineItem->id, $result->id, '$result->name', '$lineItem->sku', $lineItem->quantity, '$lineItem->fulfillment_status', '".str_replace("'", "\'", json_encode($lineItem))."')";
                DB::statement($sql);
            }
        }

        $sql = '
CREATE TEMPORARY TABLE IF NOT EXISTS temporary_shopify_refund_line_items (
    `refund_line_item_id` bigint(20) unsigned,
    `line_item_id` bigint(20) unsigned,
    `shopify_sales_order_id` bigint(20) unsigned,
    `sales_order_name` varchar(255),
    `quantity` int(11),
    `restock_type` varchar(255),
    `json_object` mediumtext,
    PRIMARY KEY (`refund_line_item_id`), INDEX(`line_item_id`), INDEX (`quantity`)
) ENGINE=InnoDB DEFAULT COLLATE utf8_unicode_ci
        ';

        DB::statement($sql);

        $results = DB::select('SELECT id, `name`, JSON_EXTRACT(json_object, "$.refunds[*].refund_line_items") as refunds FROM shopify_orders WHERE JSON_LENGTH(JSON_UNQUOTE(JSON_EXTRACT(json_object, "$.refunds"))) > 0;');
        $this->info(count($results));

        foreach ($results as $result) {
            $refunds = json_decode($result->refunds);
            foreach ($refunds as $refund) {
                foreach ($refund as $refund_line) {
                    if ($refund_line->restock_type != 'no_restock') {
                        continue;
                    }
                    $sql = "INSERT INTO temporary_shopify_refund_line_items VALUES($refund_line->id, $refund_line->line_item_id, $result->id, '$result->name', $refund_line->quantity, '$refund_line->restock_type', '".str_replace("'", "\'", json_encode($refund_line))."')";
                    DB::statement($sql);
                }
            }
        }

        $sql = '
CREATE TEMPORARY TABLE IF NOT EXISTS temporary_shopify_fulfillment_line_items (
    `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
    `line_item_id` bigint(20) unsigned,
    `fulfillment_id` bigint(20) unsigned,
    `shopify_sales_order_id` bigint(20) unsigned,
    `sales_order_name` varchar(255),
    `quantity` int(11),
    `fulfillment_status` varchar(255),
    `json_object` mediumtext,
    PRIMARY KEY (`id`), INDEX(`line_item_id`), INDEX (`quantity`)
) ENGINE=InnoDB DEFAULT COLLATE utf8_unicode_ci
        ';

        DB::statement($sql);

        $results = DB::select('SELECT id, `name`, JSON_EXTRACT(json_object, "$.fulfillments[*].id") as fulfillment_ids, JSON_EXTRACT(json_object, "$.fulfillments[*].line_items") as fulfillments FROM shopify_orders WHERE JSON_LENGTH(JSON_UNQUOTE(JSON_EXTRACT(json_object, "$.fulfillments"))) > 0;');
        $this->info(count($results));

        foreach ($results as $result) {
            $fulfillments = json_decode($result->fulfillments);
            $fulfillment_ids = explode(',', trim(trim($result->fulfillment_ids, '['), ']'));

            $i = 0;
            foreach ($fulfillments as $fulfillment) {
                $fulfillment_id = $fulfillment_ids[$i];
                foreach ($fulfillment as $fulfillment_line) {
                    $sql = "INSERT INTO temporary_shopify_fulfillment_line_items VALUES(NULL, $fulfillment_line->id, $fulfillment_id, $result->id, '$result->name', $fulfillment_line->quantity, '$fulfillment_line->fulfillment_status', '".str_replace("'", "\'", json_encode($fulfillment_line))."')";
                    DB::statement($sql);
                }
                $i++;
            }
        }

        /*
         * Now want to write query with just the suspects
         */

        $sql = '
SELECT li.line_item_id, li.sku, li.sales_order_name, li.quantity  FROM temporary_shopify_line_items AS li 
LEFT JOIN temporary_shopify_refund_line_items AS rli 
    ON rli.line_item_id = li.line_item_id
LEFT JOIN temporary_shopify_fulfillment_line_items AS fli 
    ON fli.line_item_id = li.line_item_id
INNER JOIN sales_order_lines AS sol
    ON sol.sales_channel_line_id = li.line_item_id
WHERE sol.no_audit_trail = false
GROUP BY li.line_item_id, li.sku, li.sales_order_name, li.quantity
HAVING sum(fli.quantity) < li.quantity AND sum(rli.quantity) < li.quantity
ORDER BY li.sales_order_name
        ';

        $results = DB::select($sql);

        $this->info('There are '.count($results).' potential sales order lines needing fixing');

        foreach ($results as $result) {
            $this->info($result->sku.' on '.$result->sales_order_name.' (ID: '.$result->line_item_id.') QTY: '.$result->quantity);
        }
    }
}
