<?php

namespace App\Console\Commands\Inventory;

use App\Jobs\InventorySnapshotJob;
use Illuminate\Console\Command;

class InventorySnapshotCommand extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'sku:inventory:snapshot {--productIds=}';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Take an Inventory Snapshot';

    /**
     * Create a new command instance.
     *
     * @return void
     */
    public function __construct()
    {
        parent::__construct();
    }

    /**
     * Execute the console command.
     */
    public function handle(): void
    {
        $productIds = [];
        if ($this->option('productIds')) {
            $productIds = explode(',', $this->option('productIds'));
        }
        dispatch(new InventorySnapshotJob($productIds));
    }
}
