<?php

namespace App\Console\Commands\Inventory\Integrity;

use App\Console\Commands\Inventory\Integrity\Contracts\Identifier;
use App\Console\Commands\Inventory\Integrity\Contracts\Remedy;
use App\Models\Shopify\ShopifyOrder;

class UnprocessedSalesCredits extends Integrity implements Identifier, Remedy
{
    public function identify(): void
    {
        $total = CleanupExtraSalesCreditsCommand::unprocessedRefundsQuery()->count();
        $this->addMessage('There are '.$total.' unprocessed Shopify sales credits.', $total);
    }

    public function examples(): void
    {
        $query = CleanupExtraSalesCreditsCommand::unprocessedRefundsQuery();
        $this->printMessage("EXAMPLES - Unprocessed Sales Credits:\n");

        /** @var ShopifyOrder $order */
        foreach ($query->take(5)->get() as $order) {
            $this->printMessage($order->name."\n");
        }
    }

    public function description(): string
    {
        return 'Process pending sales credits for Shopify';
    }

    public function remedy(): void
    {
        (new CleanupExtraSalesCreditsCommand)->handle();
    }
}
