<?php

namespace App\Console\Commands\Inventory\Health\Fix;

use App\Console\Commands\Inventory\Health\Fix\Traits\FixSalesOrderLinesTrait;
use App\Console\Commands\Inventory\Health\AbstractInventoryHealthCommandHelper;
use App\Models\SalesOrderLine;
use Illuminate\Database\Eloquent\Builder;
use Throwable;

class FixStaleSalesOrderLineLayersCacheCommandHelper extends AbstractInventoryHealthCommandHelper
{
    use FixSalesOrderLinesTrait;

    public function getDescription(): string
    {
        return 'Sales order lines with stale layer cache (either Missing or outdated)';
    }

    public function getQuery(): Builder
    {
        return $this->health->salesOrderLinesWithInvalidLayerCacheQuery();
    }

    /** @var SalesOrderLine $dataItem */
    protected function getFixLabel(mixed $dataItem): string
    {
        return "Fixing for sales order {$dataItem->salesOrder->sales_order_number} line $dataItem->id with SKU {$dataItem->product->sku} for quantity $dataItem->quantity";
    }

    /**
     * @throws Throwable
     * @var SalesOrderLine $dataItem
     */
    protected function fix($dataItem): void
    {
        $this->healthManager->fixSalesOrderLineLayerCache($dataItem);
    }
}