<?php

namespace App\Console\Commands\Inventory\Health\Fix;

use App\Console\Commands\Inventory\Health\AbstractInventoryHealthCommandHelper;
use App\Console\Commands\Inventory\Health\Fix\Traits\FixInventoryMovementsTrait;
use App\Models\InventoryMovement;
use Illuminate\Database\Eloquent\Builder;
use Throwable;

class FixOrphanSalesOrderLineReservationMovementsCommandHelper extends AbstractInventoryHealthCommandHelper
{
    use FixInventoryMovementsTrait;

    public function getDescription(): string
    {
        return 'Fix Orphan Sales Order Line Reservation Movements where the sales order line no longer exists';
    }

    public function getQuery(): Builder
    {
        return $this->health->orphanSalesOrderLineReservationMovements();
    }

    /** @var InventoryMovement $dataItem */
    protected function getFixLabel(mixed $dataItem): string
    {
        return "Fixing for inventory movement $dataItem->id line with SKU {$dataItem->product->sku} for quantity $dataItem->quantity (Reference: $dataItem->reference)";
    }

    protected function allOrNothing(): bool
    {
        return true;
    }

    /**
     * @throws Throwable
     * @var InventoryMovement $dataItem
     */
    protected function fix($dataItem): void
    {
        $this->healthManager->fixOrphanSalesOrderLineReservationMovementUsingReference($dataItem);
    }
}