<?php

namespace App\Console\Commands\Financials;

use App\Jobs\CalculateSalesOrderLineFinancialsJob;
use Illuminate\Console\Command;

class CalculateSalesOrderLineFinancialsCommand extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'sku:financials:calculate';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Calculate Sales Order Line Financials';

    /**
     * Create a new command instance.
     *
     * @return void
     */
    public function __construct()
    {
        parent::__construct();
    }

    public function handle(): void
    {
        dispatch(new CalculateSalesOrderLineFinancialsJob())->onQueue('financials');
    }
}
